% fcst_va_shares_V1.m
% 
% Forecast value-added shares using cosine transformations ... 
%       Linear trend + I(1) model
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function fcst_va_shares_V1()


% -- File Directories -- %
% datadir = 'Data/DataReplication/DataFinal/'; 
% outdir = 'Tables/';
% figdir = 'Figures/';
matdir = 'Output/';

% -- Load Data and Setup -- %
load_data;
rng(83993370);
n_draws = 5000;
period_lower = 20;       % Shortest Period 

Share_mat = sV_mat;
T_is = size(Share_mat,1);
nS = size(Share_mat,2);
i_base = 5;  % Base sector for logit transformation

% Compute q
q_is = floor(2*T_is/period_lower);
per_q_is = 2*T_is/q_is;
fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
fprintf('Number of Shortest Periods: %5.1f \n',per_q_is);

% Compute logit transformation
X_is = logit_s_to_x(Share_mat,i_base);
Y = X_is(:,1:end ~= i_base);

% Get some results from I_1 model
I_1 = 1;     % Levels data are I(1)
I_trend = 1; % Include linear trend in the projections
h_os = T_is;
[Yproj_is, Yproj_os_mean, trend_os_only, Yproj_os_draws] = fcst_y_trend(Y,q_is,h_os,n_draws,I_1,I_trend);
T_os = size(Yproj_is,1);
% Get LF estimates of Shares
Share_is = [Share_mat;NaN(T_os-T_is,size(Share_mat,2))];
Shareproj_is = logit_y_to_s(Yproj_is,i_base);
Shareproj_os_mean = logit_y_to_s(Yproj_os_mean,i_base);
Share_os_trend_only = logit_y_to_s(trend_os_only,i_base);
Shareproj_os_draws = NaN(T_os,nS,n_draws);
for i = 1:n_draws
    Shareproj_os_draws(:,:,i) = logit_y_to_s(Yproj_os_draws(:,:,i),i_base);
end
% Get Changes relative to final in-sample value
Shareproj_os_d2018_draws = Shareproj_os_draws - repmat(Shareproj_os_draws(T_is,:,:),T_os,1,1);
% Get percentiles across the draws
pct = [0.05 0.17 0.5 0.83 0.95];
Shareproj_os_quantiles = NaN(T_os,nS,length(pct));
Shareproj_os_d2018_quantiles = NaN(T_os,nS,length(pct));
for i = 1:nS
    Shareproj_os_quantiles(:,i,:) = prctile(squeeze(Shareproj_os_draws(:,i,:)),100*pct,2);
    Shareproj_os_d2018_quantiles(:,i,:) = prctile(squeeze(Shareproj_os_d2018_draws(:,i,:)),100*pct,2);
end

% Get fs calendar vector for plotting
calvec_os = calvec(1)+[0:1:T_os-1]';

% Add the trend-only Forecast
Share_os_trend = NaN(size(Shareproj_os_mean));
Share_os_trend(T_is+1:end,:) = Shareproj_os_mean(T_is,:)+Share_os_trend_only(T_is+1:end,:)-Share_os_trend_only(T_is,:);

% Save Key Results

save_variables = {'Share_is','Shareproj_is','Shareproj_os_mean','Shareproj_os_quantiles','Share_os_trend_only','Share_os_trend','Shareproj_os_d2018_quantiles'};
save([matdir 'fcst_va_shares_V1_' num2str(q_is) '.mat'],save_variables{:});
